function dateFormatter(date) {
    var today = new Date(date);
    var yyyy = today.getFullYear();
    let mm = today.getMonth() + 1; // Months start at 0!
    let dd = today.getDate();
    if (dd < 10) dd = '0' + dd;
    if (mm < 10) mm = '0' + mm;
    var formattedToday = yyyy + '-' + mm + '-' + dd;
    return formattedToday;
}

var successColor = '#76a93a';
var warningColor = '#c3973d';
var failureColor = '#c02020';

var backendIncludes = '../customAssets/backend/backendIncludes.php';
var todayDate = dateFormatter(new Date());
// var loggedInId = localStorage.getItem('loggedId');
// localStorage.subAdminId = "Smith";
// var subAdminId = localStorage.getItem('subAdminId');


$(() => {

    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'topics', //String //Mandatory
        }, (result) => {
            result = JSON.parse(result);
            result.data.forEach((item) => {
                $(".adminTopicsList").append(`<tr>
                                                <td>` + item.id + `</td>
                                                <td>
                                                    <h2 class="table-avatar">
                                                        <a class="adminTopicID" topic-id="`+ item.id + `" redirect-to="topicDetails" >` + item.name + `</a>
                                                    </h2>
                                                </td>
                                                <td>`+ dateFormatter(item.date) + `</td>
                                                <td>`+ item.status + `</td>
                                                <td class="text-end">
                                                    <div class="actions">
                                                        <a topic-id="`+ item.id + `" redirect-to="topicDetails"
                                                            class="adminTopicID btn btn-sm bg-success-light me-2">
                                                            <i class="feather-eye"></i>
                                                        </a>
                                                        <a topic-id="`+ item.id + `" redirect-to="topicEdit" 
                                                            class="adminTopicID btn btn-sm bg-danger-light">
                                                            <i class="feather-edit"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>`);
            });

        })

});

$(document).on("click", ".adminTopicID", function () {
    localStorage.adminTopicID = $(this).attr("topic-id");
    window.location.replace("../" + $(this).attr("redirect-to") + "/");
});