function dateFormatter(date) {
    var today = new Date(date);
    var yyyy = today.getFullYear();
    let mm = today.getMonth() + 1; // Months start at 0!
    let dd = today.getDate();
    if (dd < 10) dd = '0' + dd;
    if (mm < 10) mm = '0' + mm;
    var formattedToday = yyyy + '-' + mm + '-' + dd;
    return formattedToday;
}

var successColor = '#76a93a';
var warningColor = '#c3973d';
var failureColor = '#c02020';

var backendIncludes = '../customAssets/backend/backendIncludes.php';
var todayDate = dateFormatter(new Date());

// Setting and Getting local Storage -----------------------------
// localStorage.lastname = "Smith";
// localStoragegetItem('lastname'));
// localStorage.removeItem("loggedInId");

$(document).on("click", ".topicAddSubmitBtn", function () {
    $(this).attr('disabled', true);

    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'topics', //String //Mandatory
            conditions: "WHERE name = '" + $('.topicName').val() + "'", //String //Non Mandatory
        }, (result) => {
            result = JSON.parse(result);

            if (result.data.length > 0) {
                notificationTrigger('Topic with the same name exists', failureColor);
                $(this).attr('disabled', false);
            } else {

                $.post(backendIncludes,
                    {
                        requestType: 'insertQuery',
                        table: 'topics', //String //Mandatory
                        parameters: { // Object // Mandatory
                            name: $(".topicName").val(),
                            about: $(".topicDescription").val(),
                            status: 'Active',
                            date: todayDate
                        }
                    }, (result) => {
                        result = JSON.parse(result);
                        if (result.status) {
                            notificationTrigger('Topic Added Successfully', successColor);
                            setTimeout(() => {
                                window.location.replace("../topics/");
                            }, 2000);
                        }
                    });

            }
        });

}); 