function dateFormatter(date) {
    var today = new Date(date);
    var yyyy = today.getFullYear();
    let mm = today.getMonth() + 1; // Months start at 0!
    let dd = today.getDate();
    if (dd < 10) dd = '0' + dd;
    if (mm < 10) mm = '0' + mm;
    var formattedToday = yyyy + '-' + mm + '-' + dd;
    return formattedToday;
}

var successColor = '#76a93a';
var warningColor = '#c3973d';
var failureColor = '#c02020';

var backendIncludes = '../customAssets/backend/backendIncludes.php';
var todayDate = dateFormatter(new Date());
var loggedInId = localStorage.getItem('loggedId');
// localStorage.subAdminId = "Smith";
// var subAdminId = localStorage.getItem('subAdminId');

$(document).on("click", ".adminSubAdminAddBtn", () => {
    $(".adminSubAdminAddBtn").attr("disabled", true);
    if ($(".email").val() == '') {
        $(".adminSubAdminAddBtn").attr("disabled", false);
        notificationTrigger('Email ID is Mandatory', warningColor);
    } else {
        $.post(backendIncludes,
            {
                requestType: 'selectQuery',
                table: 'admin', //String //Mandatory
                conditions: "WHERE email = '" + $(".email").val() + "'", //String //Non Mandatory
            }, (result) => {
                result = JSON.parse(result);
                console.log(result)
                if (result.data.length > 0) {
                    $(".adminSubAdminAddBtn").attr("disabled", false);
                    notificationTrigger('Email ID is already in Use...', warningColor);
                } else {

                    $.post(backendIncludes,
                        {
                            requestType: 'insertQuery',
                            table: 'admin', //String //Mandatory
                            parameters: { // Object // Mandatory
                                fname: $(".fname").val(),
                                lname: $(".lname").val(),
                                gender: $(".gender").val(),
                                phone: $(".phone").val(),
                                email: $(".email").val(),
                                address: $(".address").val(),
                                state: $(".state").val(),
                                city: $(".city").val(),
                                zip: $(".zip").val(),
                                country: $(".country").val(),
                                role: 'Sub Admin',
                                status: 'Active'
                            },
                            // blob: {
                            //     profilePic: 'image.src' //String //Optional
                            // }
                        }, (result) => {
                            console.log(result);
                            result = JSON.parse(result);
                            if (result.status) {
                                notificationTrigger('SubAdmin added Successfully', result.notificationbg);
                                setTimeout(() => {
                                    window.location.replace("../subAdmins/");
                                }, 2000);
                            }
                        });

                }

            });


    }
});