
var backendIncludes = '../customAssets/backend/backendIncludes.php';

$(function () {

    // Students List ----------------------

    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'students', //String //Mandatory
        }, (result) => {
            result = JSON.parse(result);
            console.log(result)
            if (result.status) {

                result.data.forEach((item) => {
                    $(".adminStudentsList").append(`<tr>
                                                        <td class="text-nowrap">
                                                            <div>`+ item.id + `</div>
                                                        </td>
                                                        <td class="text-nowrap">
                                                            <a href="#">
                                                                <img class="rounded-circle"
                                                                    src="./../../student/customAssets/images/profiles/`+ item.profilePic + `"
                                                                    onerror="this.onerror=null;this.src='../customAssets/images/profiles/defaultProfilePic.png';"
                                                                    width="25" alt="Star Students">
                                                                `+ item.fname + `
                                                            </a>
                                                        </td>
                                                        <td class="text-center">`+ item.course + `</td>
                                                        <td class="text-center">`+ item.phone + `</td>
                                                        <td class="text-center">`+ item.status + `</td>
                                                        <td class="text-end">
                                                            <div class="actions ">
                                                                <a 
                                                                    class="adminStudentId btn btn-sm bg-success-light me-2 "
                                                                    student-id="`+ item.id + `" redirect-to="studentDetails"
                                                                >
                                                                    <i class="feather-eye"></i>
                                                                </a>
                                                                <a class="adminStudentId btn btn-sm bg-danger-light"
                                                                    student-id="`+ item.id + `" redirect-to="studentEdit"
                                                                >
                                                                    <i class="feather-edit"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>`);
                });
            } else { }
        });

});

$(document).on("click", ".adminStudentId", function () {
    localStorage.adminStudentId = $(this).attr("student-id");
    window.location.replace("../" + $(this).attr("redirect-to") + "/");
});

$(document).on("input", ".adminStudentsSearchByName, .adminStudentsSearchByPhone, .adminStudentsSearchByCourse", function () {
    var adminStudentsSearchByNameQuery = ($(".adminStudentsSearchByName").val() == '') ? " " : " fname LIKE '%" + $(".adminStudentsSearchByName").val() + "%' AND";
    var adminStudentsSearchByPhoneQuery = ($(".adminStudentsSearchByPhone").val() == '') ? " " : " phone LIKE '%" + $(".adminStudentsSearchByPhone").val() + "%' AND";
    var adminStudentsSearchByCourseQuery = ($(".adminStudentsSearchByCourse").val() == '') ? " " : " course LIKE '%" + $(".adminStudentsSearchByCourse").val() + "%' AND";
    var genericFilter = "1 = 1"
    console.log(adminStudentsSearchByNameQuery, adminStudentsSearchByPhoneQuery, adminStudentsSearchByCourseQuery, genericFilter)
    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'students', //String //Mandatory
            conditions: "WHERE " + adminStudentsSearchByNameQuery + adminStudentsSearchByPhoneQuery + adminStudentsSearchByCourseQuery + genericFilter
        }, (result) => {
            result = JSON.parse(result);

            if (result.status) {
                $(".adminStudentsList").html('');
                result.data.forEach((item) => {
                    $(".adminStudentsList").append(`<tr>
                                                        <td class="text-nowrap">
                                                            <div>`+ item.id + `</div>
                                                        </td>
                                                        <td class="text-nowrap">
                                                            <a href="#">
                                                                <img class="rounded-circle"
                                                                    src="./../../student/customAssets/images/profiles/`+ item.profilePic + `"
                                                                    onerror="this.onerror=null;this.src='../customAssets/images/profiles/defaultProfilePic.png';"
                                                                    width="25" alt="Star Students">
                                                                `+ item.fname + `
                                                            </a>
                                                        </td>
                                                        <td class="text-center">`+ item.course + `</td>
                                                        <td class="text-center">`+ item.phone + `</td>
                                                        <td class="text-center">`+ item.status + `</td>
                                                        <td class="text-end">
                                                            <div class="actions ">
                                                                <a 
                                                                    class="adminStudentDetails btn btn-sm bg-success-light me-2 "
                                                                    student-id="`+ item.id + `"
                                                                >
                                                                    <i class="feather-eye"></i>
                                                                </a>
                                                                <a href="../studentEdit/" class="btn btn-sm bg-danger-light">
                                                                    <i class="feather-edit"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>`);
                });
            } else { }
        });

});