
function dateFormatter(date) {
    var today = new Date(date);
    var yyyy = today.getFullYear();
    let mm = today.getMonth() + 1; // Months start at 0!
    let dd = today.getDate();
    if (dd < 10) dd = '0' + dd;
    if (mm < 10) mm = '0' + mm;
    var formattedToday = yyyy + '-' + mm + '-' + dd;
    return formattedToday;
}

var backendIncludes = '../customAssets/backend/backendIncludes.php';
var todayDate = dateFormatter(new Date());
var studentId = localStorage.getItem('adminStudentId');

$(function () {

    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'students', //String //Mandatory
            conditions: 'WHERE id =' + studentId, //String //Non Mandatory
        }, (result) => {
            result = JSON.parse(result);
            result.data.forEach((item) => {
                $(".fname").val(item.fname);
                $(".lname").val(item.lname);
                $(".email").val(item.email);
                $(".dob").val(item.dob);
                $(".gender").val(item.gender);
                $(".course").val(item.course);
                $(".phone").val(item.phone);
                $(".about").val(item.about);
                $(".address").val(item.address);
            });
        });

});


$(document).on("click", ".updateStudentSubmitBtn", function () {
    $(this).attr("disabled", true);
    if ($(".email").val() == '') {
        notificationTrigger('Email ID is mandatory', '#c3973d');
        $(".updateStudentSubmitBtn").attr("disabled", false);
    } else {
        $.post(backendIncludes,
            {
                requestType: 'updateQuery',
                table: 'students', //String //Mandatory
                // blob: {
                //     profilePic: $(".profilePic").val()
                // },
                conditions: {
                    id: studentId
                },
                parameters: { // Object // Mandatory
                    fname: $(".fname").val(),
                    lname: $(".lname").val(),
                    email: $(".email").val(),
                    dob: $(".dob").val(),
                    gender: $(".gender").val(),
                    course: $(".course").val(),
                    phone: $(".phone").val(),
                    password: '49cc991c053ba034e97fc497c18c5670',
                    about: $(".about").val(),
                    address: $(".address").val(),
                    date: todayDate
                }
            }, (result) => {
                result = JSON.parse(result);
                if (result.status) {
                    $(".updateStudentSubmitBtn").attr("disabled", false);
                    notificationTrigger('Profile updated Successfully', result.notificationbg);
                    setTimeout(() => {
                        window.location.replace("../students/");
                    }, 2000)
                } else {
                    $(".updateStudentSubmitBtn").attr("disabled", false);
                    notificationTrigger('Some error Occured. Please try again', '#c3973d')
                }
            });
    }
});