var backendIncludes = '../customAssets/backend/backendIncludes.php';

function dateFormatter(date) {
    var today = new Date(date);
    var yyyy = today.getFullYear();
    let mm = today.getMonth() + 1; // Months start at 0!
    let dd = today.getDate();
    if (dd < 10) dd = '0' + dd;
    if (mm < 10) mm = '0' + mm;
    var formattedToday = yyyy + '-' + mm + '-' + dd;
    return formattedToday;
}
var todayDate = dateFormatter(new Date());

var successColor = '#76a93a';
var warningColor = '#c3973d';
var failureColor = '#c02020';
// notificationTrigger(result.notification, result.notificationbg);

// localStorage.lastname = "Smith";
// localStorage.getItem('lastname');
// localStorage.removeItem("loggedInId");

$(() => {

    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'exams', //String //Mandatory
            orderBy: 'id', //String // Non Mandatory
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                result.data.forEach((item) => {

                    $(".examsList").append(`<tr exam-id="${item.id}">
                                                <td>PRE${item.id}</td>
                                                <td>
                                                    <h2 class="table-avatar">
                                                        <a>${item.name}</a>
                                                    </h2>
                                                </td>
                                                <td subjectsExam-id="${item.id}"></td>
                                                <td questionsCountExam-id="${item.id}">0</td>
                                                <td>${item.time} Mins</td>
                                                <td>${dateFormatter(item.date)}</td>
                                                <td>
                                                    <span class="badge badge-success">${item.status}</span>
                                                </td>
                                                <td class="text-end">
                                                    <div class="actions ">
                                                        <a  exam-id="${item.id}"
                                                            class="viewExam btn btn-sm bg-success-light me-2 ">
                                                            <i class="feather-eye"></i>
                                                        </a>
                                                        <a exam-id="${item.id}" class="viewExam btn btn-sm bg-danger-light">
                                                            <i class="feather-edit"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>`);


                    $.post(backendIncludes,
                        {
                            requestType: 'selectQuery',
                            table: 'examquestions', //String //Mandatory
                            conditions: "WHERE eId = '" + item.id + "'", //String //Non Mandatory
                        }, (resultQuestions) => {
                            resultQuestions = JSON.parse(resultQuestions);
                            if (resultQuestions.status) {
                                $('[questionsCountExam-id="' + item.id + '"]').html(resultQuestions.data.length)
                            }
                        });


                    $.post(backendIncludes,
                        {
                            requestType: 'selectQuery',
                            table: 'examsubjects', //String //Mandatory
                            conditions: "WHERE eId = '" + item.id + "'", //String //Non Mandatory
                        }, (resultSubjectsId) => {
                            resultSubjectsId = JSON.parse(resultSubjectsId);
                            if (resultSubjectsId.status) {
                                resultSubjectsId.data.forEach((itemSubjectId) => {

                                    $.post(backendIncludes,
                                        {
                                            requestType: 'selectQuery',
                                            table: 'subjects', //String //Mandatory
                                            conditions: "WHERE id = '" + itemSubjectId.sId + "'", //String //Non Mandatory
                                        }, (resultSubject) => {
                                            resultSubject = JSON.parse(resultSubject);
                                            if (resultSubject.status) {
                                                $('[subjectsExam-id="' + item.id + '"]').append(`<span class="badge badge-success">` + resultSubject.data[0].name + `</span>`);
                                            }
                                        });

                                });
                            }

                        });
                });
            }
        });




});

$(document).on("click", ".viewExam", function () {
    localStorage.adminAddedExamId = $(this).attr("exam-id");
    window.location.replace("../examAdd/");
});

$(document).on("click", ".addExam", () => {
    $(this).attr("disabled", true);

    $.post(backendIncludes,
        {
            requestType: 'insertQuery',
            table: 'exams', //String //Mandatory
            parameters: { // Object // Mandatory
                name: 'Sample Test',
                status: 'Active',
                date: todayDate
            },
        }, (result) => {
            result = JSON.parse(result);
            localStorage.adminAddedExamId = result;
            notificationTrigger('New Test Created', successColor);
            setTimeout(() => {
                window.location.replace("../examAdd/");
            }, 2000);
        });

});