var backendIncludes = '../customAssets/backend/backendIncludes.php';

function dateFormatter(date) {
    var today = new Date(date);
    var yyyy = today.getFullYear();
    let mm = today.getMonth() + 1; // Months start at 0!
    let dd = today.getDate();
    if (dd < 10) dd = '0' + dd;
    if (mm < 10) mm = '0' + mm;
    var formattedToday = yyyy + '-' + mm + '-' + dd;
    return formattedToday;
}
var todayDate = dateFormatter(new Date());
var examId = localStorage.getItem('adminAddedExamId');

var successColor = '#76a93a';
var warningColor = '#c3973d';
var failureColor = '#c02020';
// notificationTrigger(result.notification, result.notificationbg);

// localStorage.lastname = "Smith";
// localStorage.getItem('lastname');
// localStorage.removeItem("loggedInId");

$(() => {

    // Load Exam Name ------------------------------------------
    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'exams', //String //Mandatory
            conditions: "WHERE id ='" + examId + "'", //String //Non Mandatory
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                result.data.forEach((item) => {
                    $(".examName").val(item.name)
                });
            }
        });

    // Load Subjects List In Select -------------------------------------
    $.post(backendIncludes,
        {
            requestType: 'selectLeftJoinQuery',
            tableA: 'subjects', //String //Mandatory
            tableB: 'examsubjects', //String //Mandatory
            tableAColumns: ['id', 'name'],
            columns: 'A.id,A.name',
            onConditions: "ON B.eId = '" + examId + "' AND A.id = B.sId",
            conditions: "WHERE B.sId IS NULL", //String //Non Mandatory
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                result.data.forEach((item) => {
                    $(".examAddTopicAdd").append(`<option value="` + item.name + `" subject-id="` + item.id + `">` + item.name + `</option>`);
                });
            }
        });


    // Load Subjects List  -------------------------------------
    $.post(backendIncludes,
        {
            requestType: 'selectLeftJoinQuery',
            tableA: 'subjects', //String //Mandatory
            tableB: 'examsubjects', //String //Mandatory
            tableAColumns: ['id', 'name'],
            columns: 'A.id,A.name',
            onConditions: "ON B.eId = '" + examId + "' AND A.id = B.sId",
            conditions: "WHERE B.sId IS NOT NULL", //String //Non Mandatory
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                result.data.forEach((item) => {
                    $.post(backendIncludes,
                        {
                            requestType: 'selectQuery',
                            table: 'examquestions', //String //Mandatory
                            conditions: "WHERE sId = '" + item.id + "' AND eId = '" + examId + "'", //String //Non Mandatory 
                        }, (topicQuestionsCount) => {
                            topicQuestionsCount = JSON.parse(topicQuestionsCount);
                            if (topicQuestionsCount.status) {

                                $.post(backendIncludes,
                                    {
                                        requestType: 'selectQuery',
                                        table: 'examsubjects', //String //Mandatory
                                        conditions: "WHERE sId = '" + item.id + "' AND eId = '" + examId + "'", //String //Non Mandatory 
                                    }, (examSubjects) => {
                                        examSubjects = JSON.parse(examSubjects);
                                        if (examSubjects.status) {

                                            $(".topicsList").append(`<div class="topicsEach" examAddTopicId="` + item.id + `">
                                                                    <span class="topicName badge badge-outline-secondary">` + item.name + `</span>
                                                                    <span class="topicName badge badge-outline-secondary">`+ topicQuestionsCount.data.length + ` <br><span class="normalFont">Questions</span></span>
                                                                    <span class="badge badge-outline-secondary">
                                                                        <input type="time" class="topicTime form-control" examAddTopicId="` + item.id + `" value="${examSubjects.data[0].time}" />
                                                                        <br><span class="normalFont">H:m</span>
                                                                    </span>
                                                                    <a class="examAddTopicRemove btn btn-info message-btns" examAddTopicId="` + item.id + `">Remove</a>
                                                                    <a class="topicAction cursor examAddQuestionsHref" examAddTopicId="` + item.id + `">View / Add
                                                                        Questions > </a>
                                                                </div>`);
                                        }
                                    });


                            }
                        });


                });
            }
        });

    //Load Questions Count on each topic -------------------------



});


$(document).on("click", ".examAddQuestionsHref", function () {
    localStorage.examAddSubjectId = $(this).attr("examAddTopicId");
    localStorage.examId = examId;
    window.location.replace("../examAddQuestions/")
});


$(document).on("input", ".examName", function () {
    $.post(backendIncludes,
        {
            requestType: 'updateQuery',
            table: 'exams',  //String //Mandatory
            parameters: {  //Object //Mandatory
                name: $(".examName").val()
            },
            conditions: {  //Object //Mandatory
                id: examId
            }
        }, (result) => { });
});


$(document).on("input", ".topicTime", function () {
    $.post(backendIncludes,
        {
            requestType: 'updateQuery',
            table: 'examsubjects',  //String //Mandatory
            parameters: {  //Object //Mandatory
                time: $(this).val()
            },
            conditions: {  //Object //Mandatory
                sId: $(this).attr("examAddTopicId"),
                eId: examId
            }
        }, (result) => { });
});




// Exam Add -----------------------------------------------------------

$(document).on("change", ".examAddTopicAdd", function () {
    let examAddTopicAdd = $(".examAddTopicAdd").val();
    if (examAddTopicAdd == 'NULL') {
        $(".topicsAddTabAddBtn").attr("disabled", true);
    } else {
        $(".topicsAddTabAddBtn").attr("disabled", false);
    }
});

$(document).on("click", ".topicsAddTabAddBtn", function () {
    let examAddTopicAdd = $(".examAddTopicAdd").val();
    let examAddTopicAddId = $(".examAddTopicAdd").find(':selected').attr("subject-id");
    $(".topicsList").append(`<div class="topicsEach" examAddTopicId="${examAddTopicAddId}">
                                <span class="topicName badge badge-outline-secondary">${examAddTopicAdd}</span>
                                <span class="topicName badge badge-outline-secondary">0 <br><span class="normalFont">Questions</span></span>
                                <span class="badge badge-outline-secondary">
                                    <input type="time" class="topicTime form-control" examAddTopicId="${examAddTopicAddId}" value="0" />
                                    <br><span class="normalFont">H:m</span>
                                </span>
                                <a class="examAddTopicRemove btn btn-info message-btns" examAddTopicId="${examAddTopicAddId}">Remove</a>
                                <a class="topicAction cursor examAddQuestionsHref" examAddTopicId="${examAddTopicAddId}">View / Add
                                    Questions > </a>
                             </div>`);
    $(".topicsAddTabAddBtn").attr("disabled", true);
    $(".examAddTopicAdd option[value='" + examAddTopicAdd + "']").css('display', 'none');
    $(".examAddTopicAdd option[value='NULL']").prop('selected', true);
    $.post(backendIncludes,
        {
            requestType: 'insertQuery',
            table: 'examsubjects', //String //Mandatory
            parameters: { // Object // Mandatory
                eId: examId,
                sId: examAddTopicAddId,
                date: todayDate
            },
        }, (result) => {
            // result = JSON.parse(result);
            // if (result.status) {
            // }
        });
});

$(document).on("click", ".examAddTopicRemove", function () {
    let topicId = $(this).attr("examAddTopicId");
    $.post(backendIncludes,
        {
            requestType: 'deleteQuery',
            table: 'examsubjects',  //String //Mandatory
            conditions: {  //Object //Mandatory
                sId: topicId,
                eId: examId
            }
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {

                $.post(backendIncludes,
                    {
                        requestType: 'deleteQuery',
                        table: 'examquestions',  //String //Mandatory
                        conditions: {  //Object //Mandatory
                            sId: topicId,
                            eId: examId
                        }
                    }, (resultSub) => {
                        if (resultSub.status) {
                            notificationTrigger('Item removed successfully', successColor);
                        }
                    });
            }
        });
    $(".topicsEach[examAddTopicId='" + topicId + "']").remove();
});


