'use strict';

var backendIncludes = '../customAssets/backend/backendIncludes.php';

// var backendIncludes = '../customAssets/backend/backendIncludes.php';

// function dateFormatter(date) {
//     var today = new Date(date);
//     var yyyy = today.getFullYear();
//     let mm = today.getMonth() + 1; // Months start at 0!
//     let dd = today.getDate();
//     if (dd < 10) dd = '0' + dd;
//     if (mm < 10) mm = '0' + mm;
//     var formattedToday = yyyy + '-' + mm + '-' + dd;
//     return formattedToday;
// }
// var todayDate = dateFormatter(new Date());

// var successColor = '#76a93a';
// var warningColor = '#c3973d';
// var failureColor = '#c02020';
// notificationTrigger(result.notification, result.notificationbg);

// Setting and Getting local Storage -----------------------------
// localStorage.lastname = "Smith";
// localStorage.getItem('lastname');
// localStorage.removeItem("loggedInId");

// setTimeout(()=>{
//     window.location.replace("../topics/");
// },2000);

//  Query ---------------------------------------------------------
// $(()=> {
//     $.post(backendIncludes,
//         {
//             
//         }, (result) => {
//             result = JSON.parse(result);
//             console.log(result);
//             if (result.status) {
//             } else {
//             }
//         });
// });

// Select Query ------------------------------------------------------- 
// requestType: 'selectQuery',
// table: 'admin', //String //Mandatory
// conditions: "WHERE id = 1 AND ..", //String //Non Mandatory
// orderBy: 'id', //String // Non Mandatory
// limit: 5 // Number // Non Mandatory

// Select Multi Query -------------------------------------------------
// requestType: 'selectMultiQuery',
// tableA: 'results', //String //Mandatory
// tableB: 'students', //String //Mandatory
// tableAParem: 'sId',
// tableBParem: 'id',
// conditions: "WHERE id = 1 AND ..", //String //Non Mandatory
// orderBy: 'id', // tableB columns only //String // Non Mandatory
// limit: 5 // Number // Non Mandatory

// Select Left Join Query -------------------------------------------------
// requestType: 'selectLeftJoinQuery',
// tableA: 'subjects', //String //Mandatory
// tableB: 'examsubjects', //String //Mandatory
// tableAColumns: ['id','name'] //Array //Mandatory
// $columns: 'A.id,A.name' //String //Mandatory
// onConditions: "ON B.eId = 6 AND A.id = B.sId", //String //Mandatory
// conditions: "WHERE B.sId IS NULL", //String //Non Mandatory
// orderBy: 'id', // tableA columns only //String // Non Mandatory
// limit: 5 // Number // Non Mandatory

// Select Distinct Query -----------------------------------------------
// requestType: 'selectDistinctQuery',
// table: 'admin', //String //Mandatory
// distinct: 'id', //String // Mandatory
// conditions: "WHERE id = 1 AND .."", //String //Non Mandatory
// orderBy: 'id', //String // Non Mandatory
// limit: 5 // Number // Non Mandatory

// Insert Query --------------------------------------------------------
// requestType: 'insertQuery',
// table: 'admin', //String //Mandatory
// parameters: { // Object // Mandatory
//     fname: 'Harry',
//     lname: 'K'
// },
// blob: {
//      profilePic: 'image.src' //String //Optional
// }

// Update Query --------------------------------------------------------
// requestType: 'updateQuery',
// table: 'admin',  //String //Mandatory
// parameters: {  //Object //Mandatory
//     fname: 'HarryG',
//     lname: 'K'
// },
// conditions: {  //Object //Mandatory
//     id: '1'
// }

// Delete Query --------------------------------------------------------
// requestType: 'deleteQuery',
// table: 'admin',  //String //Mandatory
// conditions: {  //Object //Mandatory
//     id: '1'
// }


// Date Formatter ------

function dateFormatter(date) {
    var today = new Date(date);
    var yyyy = today.getFullYear();
    let mm = today.getMonth() + 1; // Months start at 0!
    let dd = today.getDate();

    if (dd < 10) dd = '0' + dd;
    if (mm < 10) mm = '0' + mm;

    var formattedToday = dd + '-' + mm + '-' + yyyy;
    return formattedToday;
}

// Default Loaders All Pagers--------------------------------------------------------------------------------
// Dashboard -  (session Check + Header Profile) ------------------------------------------------------------


if (document.URL.indexOf("login") >= 0 ||
    document.URL.indexOf("forgotPassword") >= 0 ||
    document.URL.indexOf("passwordReset") >= 0) { } else {
    $(function () {

        async function postIsSession() {
            var getisSession = await $.post(backendIncludes,
                {
                    requestType: 'isSession',
                }, (result) => {
                    result = JSON.parse(result);
                    if (result.status) {
                        return result;
                    } else {
                        window.location.replace("../login/");
                    }
                });
            var responseGetisSession = await getisSession;
            return JSON.parse(responseGetisSession);
        }

        postIsSession().then(data => {
            $.post(backendIncludes,
                {
                    requestType: 'selectQuery',
                    table: 'admin', //String //Mandatory
                    conditions: "WHERE email = '" + data.sessionEail + "'", //String //Non Mandatory
                    limit: '1' // String // Non Mandatory
                }, (result) => {
                    result = JSON.parse(result);
                    if (result.status) {
                        localStorage.loggedInId = result.data[0].id;
                        $(".adminName").text(result.data[0].fname);
                        $(".adminRole").text(result.data[0].role);
                        let profilePicSrc = (result.data[0].role == '' || result.data[0].role == undefined) ? result.data[0].role : '../customAssets/images/profiles/defaultProfilePic.png';
                        $(".adminProfilePic").attr("src", profilePicSrc)
                    } else {
                        localStorage.removeItem("loggedInId");
                        window.location.replace("../login/");
                    }
                });

        }).catch(err => {
            console.log(err);
        });

    });
}


// passwordToggle ------------------------------------------------------

$(document).on("click", ".toggle-password", function () {
    if ($(this).hasClass("feather-eye")) {
        $(this).removeClass("feather-eye");
        $(this).addClass("feather-eye-off");
        $(this).closest(".form-group").find(".pass-input").attr("type", "text");
    } else {
        $(this).closest(".form-group").find(".pass-input").attr("type", "password");
        $(this).removeClass("feather-eye-off");
        $(this).addClass("feather-eye");
    }
});


// logout ---------------------------------------------------------------

$(document).on("click", ".logout", () => {
    $.post(backendIncludes,
        {
            requestType: 'logout',
        }, () => {
            window.location.replace("../login/");
        });
});

// loginPageParent -------------------------------------------------------

$(document).on("click", ".adminLoginSubmitBtn", function () {
    $(this).attr("disabled", true);
    $.post(backendIncludes,
        {
            requestType: 'login',
            email: $(".adminLoginEmail").val(),
            password: $(".adminLoginPassword").val(),
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                notificationTrigger(result.notification, result.notificationbg);
                window.location.replace("../dashboard/");
            } else {
                notificationTrigger(result.notification, result.notificationbg)
            }
            $(this).attr("disabled", false);
        })
});


// adminForgotPassword ---------------------------------------------------

$(".adminForgotPasswordResetLinkBtn").on("click", function () {
    $(this).attr("disabled", true);
    let forgotEmail = $(".adminForgotPasswordEmail").val();
    $.post(backendIncludes,
        {
            requestType: 'forgotPassword',
            email: forgotEmail
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                notificationTrigger(result.notification, result.notificationbg);
                $(".passwordResetLinkRequest").css("display", "none");
                $(".passwordResetLinkSent").css("display", "block");
            } else {
                notificationTrigger(result.notification, result.notificationbg)
            }
            $(this).attr("disabled", false);
        });
});










// Modal Stuff ----------------------------------------------------

$(document).on("click", ".modalTriggerBtn", function () {
    $(".notifyTitle").html($(this).attr("notify-title"));
    $(".notifyBody").html($(this).attr("notify-body"));
});

function notificationTrigger(content, bgColor) {
    $(".notificationIndi").html("");
    $(".notificationIndi").removeClass("move");
    $(".notificationIndi").addClass("move");
    $(".notificationIndi").html(content);
    $(".notificationIndi").css("background", bgColor);
    setTimeout(() => {
        $(".notificationIndi").html("");
        $(".notificationIndi").removeClass("move");
    }, 3000);
}

$(document).on("click", ".modalResultTrue", function () {
    let content = 'Action triggered successfully';
    notificationTrigger(content);
});




