<?php 
// Session Check ---------------------------------------
    function sessionCheck($conn) {
        if(isset($_SESSION['email'])) {
            $email = $_SESSION['email'];
            $sqlSessionCheck = "SELECT * FROM admin WHERE email = ?";
            $stmtSessionCheck = $conn->prepare($sqlSessionCheck);
            $stmtSessionCheck->bind_param('s',$email);
            $stmtSessionCheck->execute();
            $resultSessionCheck = $stmtSessionCheck->get_result();
            if($resultSessionCheck->num_rows > 0) {
                return $email;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

// emailCheck -------------------------------------------
    function emailCheck($conn,$email) {
        $sqlEmailCheck = "SELECT * FROM admin WHERE email = ?";
        $stmtEmailCheck = $conn->prepare($sqlEmailCheck);
        $stmtEmailCheck->bind_param('s',$email);
        $stmtEmailCheck->execute();
        $resultEmailCheck = $stmtEmailCheck->get_result();
        if($resultEmailCheck->num_rows > 0) {
            return true;
        } else {
            return false;
        }
    }

// credentialsCheck -------------------------------------------
    function credentialsCheck($conn,$email,$password) {
        $sqlCredentialsCheck = "SELECT * FROM admin WHERE email = ? AND password = ?";
        $stmtCredentialsCheck = $conn->prepare($sqlCredentialsCheck);
        $stmtCredentialsCheck->bind_param('ss',$email,$password);
        $stmtCredentialsCheck->execute();
        $resultCredentialsCheck = $stmtCredentialsCheck->get_result();
        if($resultCredentialsCheck->num_rows > 0) {
            return true;
        } else {
            return false;
        }
    }

// PasswordReset -----------------------------------------------
    function passwordReset($conn,$email) {
        $token = substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 26);
        
        $stmt = $conn->prepare("UPDATE admin SET token=? WHERE email=?");
        $stmt->bind_param("ss", $token,$email);
        $stmt->execute();
        $stmt->close();
        $conn->close();
        return true;
    }


// Select Query -------------------------------------------------
    function selectQuery($conn,$table,$conditions,$orderBy,$limit) {

        $sqlGetTable = 'DESCRIBE '.$table;
        $resultGetTable = mysqli_query($conn, $sqlGetTable);
        $rowsGetTable = array();
        while($rowGetTable = mysqli_fetch_assoc($resultGetTable)) {
            $rowsGetTable[] = $rowGetTable['Field'];
        }

        $selectQueryResult = [];
        $sqlSelectQuery = "SELECT * FROM $table $conditions $orderBy $limit";
        $resultSelectQuery = $conn->query($sqlSelectQuery);
        if ($resultSelectQuery->num_rows > 0) {   
        while($rowSelectQuery = $resultSelectQuery->fetch_assoc()) { 
            $selectQueryResultIndie = [];
            foreach($rowsGetTable as $column) {
                $selectQueryResultIndie[$column] = $rowSelectQuery[$column];
            }
            $selectQueryResultIndie = (object)$selectQueryResultIndie;
            array_push($selectQueryResult,$selectQueryResultIndie);
        } } else { }
        return $selectQueryResult;
    }


// Select Query Multiple(joining 2 tables)  -------------------------------------------------
function selectMultiQuery($conn,$tableA,$tableB,$tableAParem,$tableBParem,$conditions,$orderBy,$limit) {

    $sqlGetTableA = 'DESCRIBE '.$tableA;
    $resultGetTableA = mysqli_query($conn, $sqlGetTableA);
    $rowsGetTableA = array();
    while($rowGetTableA = mysqli_fetch_assoc($resultGetTableA)) {
        $rowsGetTableA[] = $rowGetTableA['Field'];
    }

    $sqlGetTableB = 'DESCRIBE '.$tableB;
    $resultGetTableB = mysqli_query($conn, $sqlGetTableB);
    $rowsGetTableB = array();
    while($rowGetTableB = mysqli_fetch_assoc($resultGetTableB)) {
        $rowsGetTableB[] = $rowGetTableB['Field'];
    }

    $selectQueryResult = [];
    $sqlSelectQuery = "SELECT * FROM $tableB AS B JOIN (SELECT * FROM $tableA) AS A ON A.$tableAParem = B.$tableBParem $conditions $orderBy $limit";
    $resultSelectQuery = $conn->query($sqlSelectQuery);
    if ($resultSelectQuery->num_rows > 0) {   
    while($rowSelectQuery = $resultSelectQuery->fetch_assoc()) { 
        $selectQueryResultIndie = [];
        foreach($rowsGetTableA as $column) {
            $selectQueryResultIndie[$column] = $rowSelectQuery[$column];
        }
        foreach($rowsGetTableB as $column) {
            $selectQueryResultIndie[$column] = $rowSelectQuery[$column];
        }
        $selectQueryResultIndie = (object)$selectQueryResultIndie;
        array_push($selectQueryResult,$selectQueryResultIndie);
    } } else { }
    return $selectQueryResult;
}



// Select Query Left Join (joining left table with right one )  -------------------------------------------------
function selectLeftJoinQuery($conn,$tableA,$tableB,$tableAColumns,$columns,$onConditions,$conditions,$orderBy,$limit) {

    // $sqlGetTableA = 'DESCRIBE '.$tableA;
    // $resultGetTableA = mysqli_query($conn, $sqlGetTableA);
    // $rowsGetTableA = array();
    // while($rowGetTableA = mysqli_fetch_assoc($resultGetTableA)) {
    //     $rowsGetTableA[] = $rowGetTableA['Field'];
    // }
    
    $rowsGetTableA = $tableAColumns;

    // $sqlGetTableB = 'DESCRIBE '.$tableB;
    // $resultGetTableB = mysqli_query($conn, $sqlGetTableB);
    // $rowsGetTableB = array();
    // while($rowGetTableB = mysqli_fetch_assoc($resultGetTableB)) {
    //     $rowsGetTableB[] = $rowGetTableB['Field'];
    // }

    $selectQueryResult = [];
    $sqlSelectQuery = "SELECT $columns FROM $tableA AS A LEFT JOIN $tableB AS B $onConditions $conditions $orderBy $limit";
    $resultSelectQuery = $conn->query($sqlSelectQuery);
    if ($resultSelectQuery->num_rows > 0) {   
    while($rowSelectQuery = $resultSelectQuery->fetch_assoc()) { 
        $selectQueryResultIndie = [];
        foreach($rowsGetTableA as $column) {
            $selectQueryResultIndie[$column] = $rowSelectQuery[$column];
        }
        // foreach($rowsGetTableB as $column) {
        //     $selectQueryResultIndie[$column] = $rowSelectQuery[$column];
        // }
        $selectQueryResultIndie = (object)$selectQueryResultIndie;
        array_push($selectQueryResult,$selectQueryResultIndie);
    } } else { }
    // return $rowsGetTableA;
    // return $tableAColumns;
    return $selectQueryResult;
}


// Select Disctict Query -------------------------------------------------
function selectDistinctQuery($conn,$table,$conditions,$distinct,$orderBy,$limit) {

    $distinctQuery = 'DISTINCT('.$distinct.')';
    // $sqlGetTable = 'DESCRIBE '.$table;
    // $resultGetTable = mysqli_query($conn, $sqlGetTable);
    // $rowsGetTable = array();
    // while($rowGetTable = mysqli_fetch_assoc($resultGetTable)) {
    //     $rowsGetTable[] = $rowGetTable['Field'];
    // }

    $selectDistinctQueryResult = [];
    $sqlSelectDistinctQuery = "SELECT $distinctQuery FROM $table $conditions $orderBy $limit";
    $resultSelectDistinctQuery = $conn->query($sqlSelectDistinctQuery);
    if ($resultSelectDistinctQuery->num_rows > 0) {   
    while($rowSelectDistinctQuery = $resultSelectDistinctQuery->fetch_assoc()) { 
        $selectDistinctQueryResultIndie = [];
            $selectDistinctQueryResultIndie[$distinct] = $rowSelectDistinctQuery[$distinct];
        $selectDistinctQueryResultIndie = (object)$selectDistinctQueryResultIndie;
        array_push($selectDistinctQueryResult,$selectDistinctQueryResultIndie);
    } } else { }
    return $selectDistinctQueryResult;
}

// Insert Query ----------------------------------------------------------
function insertQuery($conn,$table,$parameters) {

    $placeholders = array_fill(0, count($parameters), '?');
    $placeholdersQ = array_fill(0, count($parameters), 's');

    $keys = $values = array();
    foreach($parameters as $k => $v) {
        $keys[] = $k;
        $values[] = !empty($v) ? $v : null;
    }

    $keysImploded = implode(',', $keys);
    $placeholdersImploded = implode(',', $placeholders);
    $placeholdersQImploaded = implode('', $placeholdersQ);

    $sqlPrepare = "INSERT INTO ".$table." (".$keysImploded.") VALUES (".$placeholdersImploded.")";

    $refs = [$placeholdersQImploaded];

    $stmt = $conn->prepare($sqlPrepare);

    foreach ($values as &$val)
        $refs[] = &$val;
    call_user_func_array([$stmt, 'bind_param'], $refs);

    $stmt->execute();
    
    // return true;
    return $conn->insert_id;;
}



// Insert Query with File (Not working yet) ----------------------------------------------------------
function insertQueryNOTWORKING($conn,$table,$blob,$parameters) {

    $placeholdersP = array_fill(0, count($parameters), '?');
    $placeholdersPQ = array_fill(0, count($parameters), 's');

    $placeholdersB = array_fill(0, count($blob), '?');
    $placeholdersBQ = array_fill(0, count($blob), 's');

    $placeholders = array_merge($placeholdersP,$placeholdersB);
    $placeholdersQ = array_merge($placeholdersPQ,$placeholdersBQ);

    // $imgData = addslashes(file_get_contents($_FILES['userImage']['tmp_name']));
    // $imageProperties = getimageSize($_FILES['userImage']['tmp_name']);

    $keysP = $valuesP = array();
    foreach($parameters as $kP => $vP) {
        $keysP[] = $kP;
        $valuesP[] = !empty($vP) ? $vP : null;
    }

    $keysB = $valuesB = array();
    foreach($blob as $kB => $vB) {
        $keysB[] = $kB;
        $valuesB[] = !empty($vB) ? $vB : null;
    }

    $keysPImploded = implode(',', $keysP);
    $keysBImploded = implode(',', $keysB);
    $keysImploded = $keysPImploded.','.$keysBImploded;

    $placeholdersImploded = implode(',', $placeholders);
    $placeholdersQImploaded = implode('', $placeholdersQ);

    $valuesFinal = array_merge($valuesP,$valuesB);

    $sqlPrepare = "INSERT INTO ".$table." (".$keysImploded.") VALUES (".$placeholdersImploded.")";

    $refs = [$placeholdersQImploaded];

    $stmt = $conn->prepare($sqlPrepare);

    foreach ($valuesFinal as &$val)
        $refs[] = &$val;
    call_user_func_array([$stmt, 'bind_param'], $refs);

    $stmt->execute();

    return true;
    // return $valuesB;
}


// Update Query ----------------------------------------------------------
function updateQuery($conn,$table,$parameters,$conditions) {

    $placeholdersPQ = array_fill(0, count($parameters), 's');
    $placeholdersCQ = array_fill(0, count($conditions), 's');
    $placeholdersQ = array_merge($placeholdersPQ,$placeholdersCQ);
    $placeholdersQ = implode('', $placeholdersQ);
    $placeholdersQA = [$placeholdersQ];

    $keysP = $valuesP = array();
    foreach($parameters as $kP => $vP) {
        $keysP[] = $kP;
        $valuesP[] = !empty($vP) ? $vP : null;
    }
    foreach($keysP as $kP) {
        $keysPFinal[] = $kP.'=?';
    }
    $keysPFinalImploded = implode(',', $keysPFinal);

    $keysC = $valuesC = array();
    foreach($conditions as $kC => $vC) {
        $keysC[] = $kC;
        $valuesC[] = !empty($vC) ? $vC : null;
    }
    foreach($keysC as $kC) {
        $keysCFinal[] = $kC.'=?';
    }
    $keysCFinalImploded = implode(',', $keysCFinal);
    $keysCFinalImploded = str_replace(","," AND ",$keysCFinalImploded);

    $valuesFinal = array_merge($valuesP,$valuesC);
  

    $sqlPrepare = "UPDATE ".$table." SET ".$keysPFinalImploded." WHERE ".$keysCFinalImploded;
    $stmt = $conn->prepare($sqlPrepare);

    foreach ($valuesFinal as &$val)
        $placeholdersQA[] = &$val;
    call_user_func_array([$stmt, 'bind_param'], $placeholdersQA);

    $stmt->execute();

    return true;
}



// Delete Query ----------------------------------------------------------
function deleteQuery($conn,$table,$conditions) {

    $placeholdersQ = array_fill(0, count($conditions), 's');
    $placeholdersQ = implode('', $placeholdersQ);
    $placeholdersQA = [$placeholdersQ];

    $keysC = $valuesC = array();
    foreach($conditions as $kC => $vC) {
        $keysC[] = $kC;
        $valuesC[] = !empty($vC) ? $vC : null;
    }
    foreach($keysC as $kC) {
        $keysCFinal[] = $kC.'=?';
    }
    $keysCFinalImploded = implode(' AND ', $keysCFinal);

    $valuesFinal = $valuesC;
  

    $sqlPrepare = "DELETE FROM ".$table." WHERE ".$keysCFinalImploded;
    $stmt = $conn->prepare($sqlPrepare);

    foreach ($valuesFinal as &$val)
        $placeholdersQA[] = &$val;
    call_user_func_array([$stmt, 'bind_param'], $placeholdersQA);

    $stmt->execute();

    return true;
    // return $sqlPrepare;
}


// logout -------------------------------------------------------
    function logout() {
        unset($_SESSION['email']);
        session_destroy();  
    }
    
?>