
function dateFormatter(date) {
    var today = new Date(date);
    var yyyy = today.getFullYear();
    let mm = today.getMonth() + 1; // Months start at 0!
    let dd = today.getDate();
    if (dd < 10) dd = '0' + dd;
    if (mm < 10) mm = '0' + mm;
    var formattedToday = yyyy + '-' + mm + '-' + dd;
    return formattedToday;
}

var backendIncludes = '../customAssets/backend/backendIncludes.php';
var todayDate = dateFormatter(new Date());

// GetActiveStudentsCount + GetActiveExamsCount + GetActiveSubjects + GetRevenueSum  ----------------------
$(function () {



    // Exams Graph ---------

    var examsChart = document.getElementById("examsChart").getContext('2d');

    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'activeexams', //String //Mandatory
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                var labelsArray = [];
                var valuesArray = [];
                result.data.forEach((item) => {
                    let today = new Date(item.date);
                    let mm = today.getMonth() + 1;
                    let monthArray = ["Jan", "Feb", "Mar", "Apr", "May", "June", "July", "Aug", "Sept", "Oct", "Nov", "Dec"]
                    if (labelsArray.includes(monthArray[mm])) {
                        labelsArray.indexOf(monthArray[mm]);
                        valuesArray[labelsArray.indexOf(monthArray[mm])] = valuesArray[labelsArray.indexOf(monthArray[mm])] + 1;
                    } else {
                        labelsArray.push(monthArray[mm]);
                        valuesArray.push(1);
                    }
                });

                var myChart = new Chart(examsChart, {
                    type: 'line',
                    data: {
                        labels: labelsArray,
                        datasets: [
                            {
                                label: 'Tests', // Name the series
                                data: valuesArray, // Specify the data values array
                                fill: false,
                                borderColor: '#2196f3', // Add custom color border (Line)
                                backgroundColor: '#2196f3', // Add custom color background (Points and Fill)
                                borderWidth: 1 // Specify bar border width
                            },
                            // {
                            //     label: 'Students', // Name the series
                            //     data: [254, 500, 244, 15240, 1141, 411, 444, 427, 555, 611], // Specify the data values array
                            //     fill: false,
                            //     borderColor: '#00ecd0', // Add custom color border (Line)
                            //     backgroundColor: '#00ecd0', // Add custom color background (Points and Fill)
                            //     borderWidth: 1 // Specify bar border width
                            // }
                        ]
                    },
                    options: {
                        responsive: true, // Instruct chart js to respond nicely.
                        maintainAspectRatio: false, // Add to prevent default behaviour of full-width/height 
                    }
                });

            } else { }
        });


    // Students Graph ---------

    var studentsChart = document.getElementById("studentsChart").getContext('2d');

    $.post(backendIncludes,
        {
            requestType: 'selectQuery',
            table: 'students', //String //Mandatory
        }, (result) => {
            result = JSON.parse(result);
            if (result.status) {
                var labelsArray = [];
                var valuesArray = [];
                result.data.forEach((item) => {
                    let today = new Date(item.date);
                    let mm = today.getMonth() + 1;
                    let monthArray = ["Jan", "Feb", "Mar", "Apr", "May", "June", "July", "Aug", "Sept", "Oct", "Nov", "Dec"]
                    if (labelsArray.includes(monthArray[mm])) {
                        labelsArray.indexOf(monthArray[mm]);
                        valuesArray[labelsArray.indexOf(monthArray[mm])] = valuesArray[labelsArray.indexOf(monthArray[mm])] + 1;
                    } else {
                        labelsArray.push(monthArray[mm]);
                        valuesArray.push(1);
                    }
                });

                var myChart = new Chart(studentsChart, {
                    type: 'line',
                    data: {
                        labels: labelsArray,
                        datasets: [
                            {
                                label: 'Students', // Name the series
                                data: valuesArray, // Specify the data values array
                                fill: false,
                                borderColor: '#f59a4b', // Add custom color border (Line)
                                backgroundColor: '#f59a4b', // Add custom color background (Points and Fill)
                                borderWidth: 1 // Specify bar border width
                            },
                        ]
                    },
                    options: {
                        responsive: true, // Instruct chart js to respond nicely.
                        maintainAspectRatio: false, // Add to prevent default behaviour of full-width/height 
                    }
                });

            } else { }
        });

});